/*
 * Decompiled with CFR 0.152.
 */
package tech.thatgravyboat.creeperoverhaul.client.cosmetics.ui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import com.teamresourceful.resourcefullib.client.scissor.CloseableScissorStack;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.Cosmetic;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.CosmeticModel;
import tech.thatgravyboat.creeperoverhaul.client.cosmetics.service.CosmeticsApi;
import tech.thatgravyboat.creeperoverhaul.client.renderer.cosmetics.CosmeticRenderer;

public class CosmeticButton
extends AbstractButton {
    private final CosmeticRenderer renderer = new CosmeticRenderer();
    private final Cosmetic cosmetic;

    public CosmeticButton(Cosmetic cosmetic) {
        super(0, 0, 35, 35, CommonComponents.EMPTY);
        this.cosmetic = cosmetic;
        this.setTooltip(Tooltip.create((Component)Component.literal((String)cosmetic.name())));
    }

    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation texture = this.isHovered ? ModSprites.BUTTON_HOVER : ModSprites.BUTTON;
        graphics.blitSprite(texture, this.getX(), this.getY(), this.getWidth(), this.getHeight());
        try (CloseableScissorStack ignored = RenderUtils.createScissor((Minecraft)Minecraft.getInstance(), (GuiGraphics)graphics, (int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight());
             CloseablePoseStack stack = new CloseablePoseStack(graphics);){
            stack.translate((float)(this.getX() + 30), (float)(this.getY() + 30), 1000.0f);
            stack.mulPose(Axis.XN.rotationDegrees(180.0f));
            stack.mulPose(Axis.YN.rotationDegrees(180.0f));
            stack.scale(25.0f, 25.0f, 25.0f);
            this.cosmetic.displayTransformation().applyScale((PoseStack)stack);
            stack.translate(0.05, -0.4, 0.0);
            stack.mulPose(Axis.YP.rotationDegrees(135.0f));
            stack.translate(0.0, 0.0, 0.6);
            this.cosmetic.displayTransformation().applyRotation((PoseStack)stack);
            this.cosmetic.displayTransformation().applyTranslation((PoseStack)stack);
            MultiBufferSource.BufferSource source = Minecraft.getInstance().renderBuffers().bufferSource();
            RenderType type = RenderType.entityTranslucent((ResourceLocation)this.cosmetic.texture().getResourceLocation());
            VertexConsumer consumer = source.getBuffer(type);
            CosmeticModel model = this.cosmetic.model();
            BakedGeoModel bakedModel = model.getBakedModel(null);
            if (model.isLoaded()) {
                this.renderer.setModel(model);
                AnimationState state = new AnimationState((GeoAnimatable)this.cosmetic, 0.0f, 0.0f, partialTicks, true);
                model.setCustomAnimations(this.cosmetic, this.renderer.getInstanceId(this.cosmetic), state);
                this.renderer.reRender(bakedModel, (PoseStack)stack, (MultiBufferSource)source, this.cosmetic, type, consumer, partialTicks, 0xF000F0, OverlayTexture.NO_OVERLAY, -1);
                source.endBatch();
            }
        }
    }

    public void onPress() {
        CosmeticsApi.setCosmetic(this.cosmetic);
    }

    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }
}

